
from gurobipy import *

# Create a new model
model = Model("Jacket_Production")

# Add variables
x1 = model.addVar(lb=0, name="flight_jackets")
x2 = model.addVar(lb=0, name="denim_jackets")

# Set the objective function
model.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 10, "max_flight_jackets")
model.addConstr(x2 <= 25, "max_denim_jackets")
model.addConstr(x1 + x2 <= 30, "sewing_machine_capacity")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of flight jackets: {x1.x}")
    print(f"Number of denim jackets: {x2.x}")
    print(f"Total profit: ${70*x1.x + 100*x2.x:.2f}")
else:
    print("No optimal solution found")
