
import gurobipy as gp

# Create a new model
model = gp.Model("Jacket_Production")

# Define the variables
x1 = model.addVar(lb=0, ub=10, name="flight_jackets")
x2 = model.addVar(lb=0, ub=25, name="denim_jackets")

# Set the objective function
model.setObjective(70*x1 + 100*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 10, name="flight_jacket_limit")
model.addConstr(x2 <= 25, name="denim_jacket_limit")
model.addConstr(x1 + x2 <= 30, name="sewing_machine_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Flight jackets: {x1.varValue}")
    print(f"Denim jackets: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
