
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x1 = m.addVar(lb=0, name="Automotive_Investment")  # Investment in automotive
x2 = m.addVar(lb=0, name="Textile_Investment")  # Investment in textile

# Set objective function
m.setObjective(0.10 * x1 + 0.08 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 30000, "Total_Investment")
m.addConstr(x1 >= 3 * x2, "Automotive_Textile_Ratio")
m.addConstr(x1 <= 24000, "Max_Automotive_Investment")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in automotive: ${x1.x}")
    print(f"Optimal investment in textile: ${x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

