
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # Investment in automotive industry
    x2 = model.addVar(name='x2', lb=0)  # Investment in textile industry

    # Objective function: maximize 0.10*x1 + 0.08*x2
    model.setObjective(x1 * 0.10 + x2 * 0.08, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 30000)  # Total investment not exceeding $30000
    model.addConstr(x1 >= 3 * x2)      # Automotive investment at least three times textile investment
    model.addConstr(x1 <= 24000)       # Automotive investment not exceeding $24000

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in automotive industry: ${x1.varValue:.2f}")
        print(f"Optimal investment in textile industry: ${x2.varValue:.2f}")
        print(f"Maximal profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
