
import gurobipy as gp

# Create a new model
m = gp.Model("ToyCommercials")

# Create variables
cartoons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cartoons")
kids_movies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kids_movies")


# Set objective function
m.setObjective(5000 * cartoons + 12000 * kids_movies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * cartoons + 4 * kids_movies >= 30, "young_boys")
m.addConstr(1 * cartoons + 6 * kids_movies >= 40, "young_girls")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Number of cartoon commercials: {cartoons.x}")
    print(f"Number of kids-movie commercials: {kids_movies.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

