
from gurobipy import *

# Create a new model
m = Model("Toy_Commercials")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon_commercials", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="kids_movie_commercials", lb=0)

# Set the objective function
m.setObjective(5000*x1 + 12000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 30, "young_boys_constraint")
m.addConstr(x1 + 6*x2 >= 40, "young_girls_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of commercials during cartoons: {x1.x}")
    print(f"Number of commercials during kids-movies: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
