
import gurobipy as gp

# Create a new model
model = gp.Model("Toy_Company_Advertising")

# Define variables
x1 = model.addVar(name="cartoon_commercials", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="kids_movie_commercials", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: minimize cost
model.setObjective(5000*x1 + 12000*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(2*x1 + 4*x2 >= 30, name="young_boys_constraint")
model.addConstr(x1 + 6*x2 >= 40, name="young_girls_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
  print("Optimal Solution:")
  print(f"Cartoon commercials: {x1.varValue}")
  print(f"Kids movie commercials: {x2.varValue}")
  print(f"Minimum cost: ${model.objVal:.2f}")
else:
  print("The model is infeasible.")
