
import gurobipy as gp

# Create a new model
m = gp.Model("farm_allocation")

# Create variables
x1 = m.addVar(nonneg=True, name="acres_beets")  # Acres of beets
x2 = m.addVar(nonneg=True, name="acres_carrots") # Acres of carrots

# Set objective function
m.setObjective(200*x1 + 340*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.6*x1 + 0.7*x2 <= 10, "tractor_constraint")
m.addConstr(0.3*x1 + 0.25*x2 <= 10, "plow_constraint")
m.addConstr(0.2*x1 + 0.1*x2 <= 10, "combine_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal revenue: ${m.objVal:.2f}")
    print(f"Acres of beets: {x1.x:.2f}")
    print(f"Acres of carrots: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

