
import gurobipy as gp

# Create a new model
m = gp.Model("Farming_Optimization")

# Define variables
y_b = m.addVar(name="beet_acres", lb=0)
y_c = m.addVar(name="carrot_acres", lb=0)

# Objective function
m.setObjective(200 * y_b + 340 * y_c, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.6 * y_b + 0.7 * y_c <= 10, name="tractor_constraint")
m.addConstr(0.3 * y_b + 0.25 * y_c <= 10, name="plow_constraint")
m.addConstr(0.2 * y_b + 0.1 * y_c <= 10, name="combine_constraint")

# Solve the model
m.solve()

# Print the solution
print("Objective: ", m.objVal)
print("Beet Acres: ", y_b.varValue)
print("Carrot Acres: ", y_c.varValue)
