
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("keyboard_production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # 61 key keyboard
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # 81 key keyboard


# Set objective function
m.setObjective(1500*x1 + 2500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 16*x2 <= 3000, "oscillator_chips")
m.addConstr(1.5*x1 + 1.5*x2 <= 8, "production_time")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal revenue: ${m.objVal:.2f}")
    print(f"Number of 61-key keyboards: {x1.x:.2f}")
    print(f"Number of 81-key keyboards: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

