
from gurobipy import *

# Create a new model
m = Model("Synthesizer_Keyboard_Production")

# Define variables
x1 = m.addVar(name="x1", lb=0)  # Number of 61-key synthesizer keyboards
x2 = m.addVar(name="x2", lb=0)  # Number of 81-key synthesizer keyboards

# Set the objective function
m.setObjective(1500*x1 + 2500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 16*x2 <= 3000, name="OscillatorChipConstraint")
m.addConstr(1.5*x1 + 1.5*x2 <= 8, name="ProductionTimeConstraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of 61-key keyboards to produce: {x1.x}")
    print(f"Number of 81-key keyboards to produce: {x2.x}")
    print(f"Maximum revenue achievable: ${m.objVal}")
else:
    print("No optimal solution found. The model may be infeasible or unbounded.")
