
import gurobipy as gp

def solve_keyboard_production():
    # Create a new model
    model = gp.Model("Keyboard_Production")

    # Define variables
    x1 = model.addVar(name="x1", obj=0, vtype=gp.GRB.INTEGER, lb=0)  # 61-key keyboard quantity
    x2 = model.addVar(name="x2", obj=0, vtype=gp.GRB.INTEGER, lb=0)  # 81-key keyboard quantity

    # Set objective function coefficients
    x1.obj = 1500
    x2.obj = 2500

    # Add constraints
    model.addConstr(8 * x1 + 16 * x2 <= 3000, name="oscillator_chips")
    model.addConstr(90 * x1 + 90 * x2 <= 28800, name="production_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"61-key keyboard quantity: {x1.varValue}")
        print(f"81-key keyboard quantity: {x2.varValue}")
        print(f"Total Revenue: {1500*x1.varValue + 2500*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_keyboard_production()
