
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hotel_optimization")

# Create variables
regular_rooms = m.addVar(vtype=GRB.INTEGER, name="regular_rooms")
premium_rooms = m.addVar(vtype=GRB.INTEGER, name="premium_rooms")

# Set objective function
m.setObjective(100 * regular_rooms + 500 * premium_rooms, GRB.MAXIMIZE)

# Add constraints
m.addConstr(regular_rooms + premium_rooms <= 500, "total_rooms")
m.addConstr(regular_rooms >= 100, "min_regular")
m.addConstr(premium_rooms >= 2 * regular_rooms, "premium_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular rooms: {regular_rooms.x}")
    print(f"Number of premium rooms: {premium_rooms.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

