
from gurobipy import *

# Create a model
m = Model("Hotel_Rooms")

# Define variables
x1 = m.addVar(name="regular_rooms", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="premium_rooms", vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(100*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, name="total_rooms")
m.addConstr(x1 >= 100, name="min_regular_rooms")
m.addConstr(x2 >= 2*x1, name="premium_vs_regular")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular rooms: {x1.x}")
    print(f"Premium rooms: {x2.x}")
    print(f"Total profit: ${100*x1.x + 500*x2.x}")
else:
    print("No optimal solution found")
