
import gurobi

def solve_hotel_room_allocation():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="regular_rooms")
    x2 = model.addVar(lb=0, name="premium_rooms")

    # Objective function: Maximize 100*x1 + 500*x2
    model.setObjective(100*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="total_rooms")
    model.addConstr(x1 >= 100, name="min_regular_rooms")
    model.addConstr(x2 >= 2*x1, name="premium_vs_regular")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Regular rooms: {x1.varValue}")
        print(f"Premium rooms: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_hotel_room_allocation()
