
import gurobipy as gp

# Create a new model
m = gp.Model("bike_shop")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="mountain_bikes") # number of mountain bikes
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="road_bikes") # number of road bikes


# Set objective function
m.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "demand_constraint")
m.addConstr(750*x1 + 1000*x2 <= 40000, "cost_constraint")
m.addConstr(x1 >= 0, "non_negativity_constraint_x1")
m.addConstr(x2 >= 0, "non_negativity_constraint_x2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of mountain bikes: {x1.x}")
    print(f"Number of road bikes: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

