
from gurobipy import *

# Create a model
m = Model("Bike_Shop_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mountain_Bikes")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Road_Bikes")

# Set objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "Total_Bikes_Constraint")
m.addConstr(750*x1 + 1000*x2 <= 40000, "Total_Value_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
