
import gurobipy as gp

def solve_bike_shop_problem():
    # Create a new model
    model = gp.Model("Bike_Shop_Problem")

    # Define variables
    x1 = model.addVar(name="mountain_bikes", lb=0, vtype=gp.GRB.INTEGER)  # Number of mountain bikes
    x2 = model.addVar(name="road_bikes", lb=0, vtype=gp.GRB.INTEGER)    # Number of road bikes

    # Objective function: Maximize profit
    model.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 150, name="demand_constraint")  # Monthly demand constraint
    model.addConstr(750*x1 + 1000*x2 <= 40000, name="stock_constraint")  # Total worth of bikes in stock constraint

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Mountain Bikes = {x1.varValue}, Road Bikes = {x2.varValue}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_bike_shop_problem()
