
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Potato Transportation")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="regular_trucks") # number of regular truck trips
x2 = m.addVar(vtype=GRB.INTEGER, name="refrigerated_trucks") # number of refrigerated truck trips


# Set objective function
m.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 70*x2 <= 5000, "budget_constraint")
m.addConstr(x2 <= x1, "refrigerated_limit")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of regular truck trips: {x1.x}")
    print(f"Number of refrigerated truck trips: {x2.x}")
    print(f"Total packages transported: {70*x1.x + 100*x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

