
from gurobipy import *

# Create a new model
m = Model("Potato_Transport")

# Define variables
x1 = m.addVar(name="regular_truck_trips", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="refrigerated_truck_trips", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 70*x2 <= 5000, name="cost_constraint")
m.addConstr(x2 <= x1, name="trip_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular truck trips: {x1.x}")
    print(f"Refrigerated truck trips: {x2.x}")
    print(f"Total packages transported: {70*x1.x + 100*x2.x}")
else:
    print("No optimal solution found")
