
import gurobi

def solve_potato_transport_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", obj=0, lb=0, vtype=gurobi.GRB.INTEGER)  # Regular truck trips
    x2 = model.addVar(name="x2", obj=0, lb=0, vtype=gurobi.GRB.INTEGER)  # Refrigerated truck trips

    # Objective function: Maximize 70*x1 + 100*x2
    model.setObjective(70*x1 + 100*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(50*x1 + 70*x2 <= 5000, name="cost_constraint")
    model.addConstr(x2 <= x1, name="refrigerated_trips_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Regular truck trips: {x1.varValue}")
        print(f"Refrigerated truck trips: {x2.varValue}")
        print(f"Total packages: {70*x1.varValue + 100*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_potato_transport_problem()
