
import gurobipy as gp

# Create a new model
m = gp.Model("instrument_production")

# Create variables
violins = m.addVar(vtype=gp.GRB.CONTINUOUS, name="violins")
harps = m.addVar(vtype=gp.GRB.CONTINUOUS, name="harps")

# Set objective function
m.setObjective(200 * violins + 350 * harps, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * violins + 2 * harps <= 100, "woodworking_constraint")
m.addConstr(2.5 * violins + 10 * harps <= 150, "assembling_constraint")
m.addConstr(violins >= 0, "violins_nonnegative")
m.addConstr(harps >= 0, "harps_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of violins to produce: {violins.x}")
    print(f"Number of harps to produce: {harps.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

