
from gurobipy import *

# Create a new model
m = Model("Instrument_Production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="violins")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="harps")

# Set the objective function
m.setObjective(200*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 2*x2 <= 100, "woodworking_time")
m.addConstr(2.5*x1 + 10*x2 <= 150, "assembling_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Violins: {x1.x}")
    print(f"Harp: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
