
import gurobipy as gp

def solve_factory_production_problem():
    # Create a new model
    model = gp.Model("Factory_Production")

    # Define variables
    x1 = model.addVar(name="violins", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="harps", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(200*x1 + 350*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x1 + 2*x2 <= 100, name="woodworking_time")
    model.addConstr(2.5*x1 + 10*x2 <= 150, name="assembling_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Violins = {x1.varValue}, Harps = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_factory_production_problem()
