
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Farm")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="coconut_acres") # Acres of coconut trees
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="banana_acres")  # Acres of banana trees

# Set objective function: Maximize profit
m.setObjective(400*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, "land_constraint")            # Land availability
m.addConstr(200*x1 + 150*x2 <= 15000, "budget_constraint") # Budget constraint
m.addConstr(5*x1 + 4*x2 <= 750, "labor_constraint")       # Labor constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    m.computeIIS()  # Compute Irreducible Inconsistent Subsystem
    m.write("model.ilp") # Write the model to a file
    print("IIS written to model.ilp")

elif m.status == GRB.OPTIMAL:

    print(f"Optimal Solution Found:\nPlant {x1.x:.2f} acres of coconut trees.")
    print(f"Plant {x2.x:.2f} acres of banana trees.")
    print(f"Maximum profit: ${m.objVal:.2f}")

else:
    print(f"Optimization terminated with status {m.status}")

