
from gurobipy import *

# Create a model
m = Model("George_Trees")

# Define variables
x1 = m.addVar(name="coconut_acres", lb=0)
x2 = m.addVar(name="banana_acres", lb=0)

# Set the objective function
m.setObjective(200*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x1 + 150*x2 <= 15000, name="budget")
m.addConstr(5*x1 + 4*x2 <= 750, name="labor")
m.addConstr(x1 + x2 <= 200, name="land")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coconut acres: {x1.x}")
    print(f"Banana acres: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
