
import gurobi as gp

# Create a new model
m = gp.Model("George's Land Optimization")

# Define the variables
x1 = m.addVar(name="coconut_trees", lb=0)  # Acres of coconut trees
x2 = m.addVar(name="banana_trees", lb=0)  # Acres of banana trees

# Objective function: Maximize profit
m.setObjective(400 * x1 + 350 * x2, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(200 * x1 + 150 * x2 <= 15000, name="budget_constraint")

# Labor constraint
m.addConstr(5 * x1 + 4 * x2 <= 750, name="labor_constraint")

# Acres of land constraint
m.addConstr(x1 + x2 <= 200, name="land_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Acres of coconut trees: {x1.varValue}")
    print(f"Acres of banana trees: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
