
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_costs")

# Create variables
standing_desks = model.addVar(vtype=gp.GRB.INTEGER, name="standing_desks")
office_chairs = model.addVar(vtype=gp.GRB.INTEGER, name="office_chairs")

# Set objective function
model.setObjective(500 * standing_desks + 230 * office_chairs, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(60 * standing_desks + 35 * office_chairs >= 2000, "machine_time")
model.addConstr(standing_desks + office_chairs >= 100, "min_items")
model.addConstr(standing_desks >=0)
model.addConstr(office_chairs >=0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: ")
    print(f"Number of standing desks: {standing_desks.x}")
    print(f"Number of office chairs: {office_chairs.x}")
    print(f"Minimum cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

