
from gurobipy import *

# Create a new model
m = Model("WFH_Factory_Optimization")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="standing_desks")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="office_chairs")

# Set the objective function
m.setObjective(500*x1 + 230*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(60*x1 + 35*x2 >= 2000, "machine_time")
m.addConstr(x1 + x2 >= 100, "total_items")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Standing desks to produce: {x1.x}")
    print(f"Office chairs to produce: {x2.x}")
    print(f"Total cost: ${500*x1.x + 230*x2.x:.2f}")
else:
    print("No optimal solution found.")
