
import gurobipy as gp

# Create a new model
model = gp.Model("StandingDesks_OfficeChairs")

# Define the variables
x1 = model.addVar(name="standing_desks", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="office_chairs", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: minimize cost
model.setObjective(500*x1 + 230*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(60*x1 + 35*x2 >= 2000, name="machine_time")
model.addConstr(x1 + x2 >= 100, name="min_items")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Standing Desks: {x1.varValue}")
    print(f"Office Chairs: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
