
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("weight_loss_program")

# Create variables
indian = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="indian") # Indian food plates
thai = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="thai") # Thai food plates


# Set objective function
m.setObjective(12*indian + 15*thai, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*indian + 8*thai >= 200, "protein_req")
m.addConstr(23*indian + 12*thai >= 50, "carb_req")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Indian food plates: {indian.x:.2f}")
    print(f"Thai food plates: {thai.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

