
from gurobipy import *

# Create a new model
m = Model("WeightLossProgram")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="IndianFood", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="ThaiFood", lb=0)

# Set the objective function
m.setObjective(12*x1 + 15*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x1 + 8*x2 >= 200, "ProteinRequirement")
m.addConstr(23*x1 + 12*x2 >= 50, "CarbRequirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of plates of Indian food: {x1.x}")
    print(f"Number of plates of Thai food: {x2.x}")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
