
import gurobipy as gp

# Create a new model
model = gp.Model("Weight Loss Program")

# Define the variables
x1 = model.addVar(name="Indian_food", lb=0)  # plates of Indian food
x2 = model.addVar(name="Thai_food", lb=0)   # plates of Thai food

# Define the objective function
model.setObjective(12 * x1 + 15 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(13 * x1 + 8 * x2 >= 200, name="protein_requirement")
model.addConstr(23 * x1 + 12 * x2 >= 50, name="carb_requirement")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Plates of Indian food: {x1.varValue:.2f}")
    print(f"Plates of Thai food: {x2.varValue:.2f}")
else:
    print("No optimal solution found.")
