
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("factory_optimization")

# Create variables
backpacks = m.addVar(vtype=GRB.INTEGER, name="backpacks")
handbags = m.addVar(vtype=GRB.INTEGER, name="handbags")

# Set objective function
m.setObjective(5 * backpacks + 8 * handbags, GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * backpacks + 15 * handbags >= 3000, "machine_time")
m.addConstr(backpacks + handbags >= 180, "min_items")
m.addConstr(backpacks >=0, "non_neg_backpacks")
m.addConstr(handbags >=0, "non_neg_handbags")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found. Objective Value: {m.objVal}")
    print(f"Number of Backpacks: {backpacks.x}")
    print(f"Number of Handbags: {handbags.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

