
from gurobipy import *

# Create a new model
m = Model("Factory_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="backpacks", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="handbags", lb=0)

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 >= 3000, "machine_time")
m.addConstr(x1 + x2 >= 180, "total_items")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of backpacks: {x1.x}")
    print(f"Number of handbags: {x2.x}")
    print(f"Total cost: ${5*x1.x + 8*x2.x:.2f}")
else:
    print("No optimal solution found")
