
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="backpacks", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="handbags", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 5*x1 + 8*x2
    model.setObjective(5*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x1 + 15*x2 >= 3000, name="machine_time")
    model.addConstr(x1 + x2 >= 180, name="total_items")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of backpacks: {x1.varValue}")
        print(f"Number of handbags: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
