
import gurobipy as gp

# Create a new model
m = gp.Model("Flower_Profit")

# Create variables
tulips = m.addVar(lb=0, name="tulips")  # Acres of tulips
daffodils = m.addVar(lb=0, name="daffodils")  # Acres of daffodils

# Set objective function: Maximize profit
m.setObjective(325 * tulips + 200 * daffodils, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(tulips + daffodils <= 200, "Total_Acres")  # Total acres constraint
m.addConstr(10 * tulips + 5 * daffodils <= 1500, "Bulb_Cost")  # Bulb cost constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {tulips.x} acres of tulips")
    print(f"Plant {daffodils.x} acres of daffodils")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

