
from gurobipy import *

# Create a new model
m = Model("tulips_and_daffodils")

# Define variables
x1 = m.addVar(lb=0, name="acres_of_tulips")
x2 = m.addVar(lb=0, name="acres_of_daffodils")

# Set the objective function
m.setObjective(325*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 <= 1500, "budget_constraint")
m.addConstr(x1 + x2 <= 200, "total_acres_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acre of tulips: {x1.x}")
    print(f"Acre of daffodils: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
