
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="tulips", lb=0, ub=200, obj=325)
    x2 = model.addVar(name="daffodils", lb=0, ub=200, obj=200)

    # Add constraints
    model.addConstr(x1 + x2 <= 200, name="total_acres")
    model.addConstr(10*x1 + 5*x2 <= 1500, name="budget")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of tulips: {x1.x}")
        print(f"Acres of daffodils: {x2.x}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
