
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="egg_sandwiches") # number of egg sandwiches
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches") # number of ham sandwiches


# Set objective function
model.setObjective(3.5 * x1 + 5 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x1 + 1 * x2 <= 50, "egg_constraint")
model.addConstr(2 * x1 + 4 * x2 <= 60, "ham_constraint")
model.addConstr(x1 >= 0, "non_negativity_x1")
model.addConstr(x2 >= 0, "non_negativity_x2")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of egg sandwiches: {x1.x}")
    print(f"Number of ham sandwiches: {x2.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

