
from gurobipy import *

# Create a new model
m = Model("FoodTruck")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="egg_sandwiches", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="ham_sandwiches", lb=0)

# Set the objective function
m.setObjective(3.5*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + x2 <= 50, "eggs")
m.addConstr(2*x1 + 4*x2 <= 60, "ham")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
