
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="egg_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="ham_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(3.5 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + x2 <= 50, name="egg_constraint")
    model.addConstr(2 * x1 + 4 * x2 <= 60, name="ham_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of egg sandwiches: {x1.varValue}")
        print(f"Number of ham sandwiches: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
