
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pizza_optimization")

# Create variables
pepperoni = m.addVar(lb=0, vtype=GRB.INTEGER, name="pepperoni")
hawaiian = m.addVar(lb=0, vtype=GRB.INTEGER, name="hawaiian")


# Set objective function
m.setObjective(4 * pepperoni + 5 * hawaiian, GRB.MAXIMIZE)

# Add constraints
m.addConstr(pepperoni >= 35, "pepperoni_min")
m.addConstr(pepperoni <= 40, "pepperoni_max")
m.addConstr(hawaiian >= 40, "hawaiian_min")
m.addConstr(hawaiian <= 70, "hawaiian_max")
m.addConstr(pepperoni + hawaiian <= 90, "total_pizza_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of pepperoni pizzas: {pepperoni.x}")
    print(f"Number of Hawaiian pizzas: {hawaiian.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

