
from gurobipy import *

# Create a new model
m = Model("Pizza_Sales")

# Define variables
x1 = m.addVar(lb=35, ub=40, vtype=GRB.INTEGER, name="pepperoni_pizzas")
x2 = m.addVar(lb=40, ub=70, vtype=GRB.INTEGER, name="hawaiian_pizzas")

# Set the objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 90, name="total_pizzas")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pepperoni pizzas to sell: {x1.x}")
    print(f"Hawaiian pizzas to sell: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
