
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_shop")

# Define the variables
x1 = m.addVar(lb=35, ub=40, name="pepperoni_pizzas")
x2 = m.addVar(lb=40, ub=70, name="hawaiian_pizzas")

# Objective function: Maximize profit
m.setObjective(4*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraint: Total pizzas cannot exceed 90
m.addConstraint(x1 + x2 <= 90)

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Pepperoni Pizzas: {x1.varValue}")
    print(f"Hawaiian Pizzas: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
