
import gurobipy as gp

# Create a new model
m = gp.Model("shed_treehouse_production")

# Create variables
sheds = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sheds")
treehouses = m.addVar(vtype=gp.GRB.CONTINUOUS, name="treehouses")


# Set objective function
m.setObjective(700 * sheds + 500 * treehouses, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * sheds + 2 * treehouses <= 40, "building_time")
m.addConstr(2 * sheds + 1.5 * treehouses <= 30, "painting_time")
m.addConstr(sheds >= 0, "sheds_nonnegative")  # Ensure non-negative production
m.addConstr(treehouses >= 0, "treehouses_nonnegative") # Ensure non-negative production

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of sheds to build: {sheds.x:.2f}")
    print(f"Number of treehouses to build: {treehouses.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

