
from gurobipy import *

# Create a new model
m = Model("Sheds_and_Treehouses")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="sheds")
x2 = m.addVar(vtype=GRB.INTEGER, name="treehouses")

# Set the objective function: Maximize profit
m.setObjective(700*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 2*x2 <= 40, "building_time")
m.addConstr(2*x1 + 1.5*x2 <= 30, "painting_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sheds: {x1.x}")
    print(f"Number of treehouses: {x2.x}")
    print(f"Maximum profit: ${700*x1.x + 500*x2.x}")
else:
    print("No optimal solution found.")
