
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="sheds")
    x2 = model.addVar(lb=0, name="treehouses")

    # Objective function
    model.setObjective(700*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 + 2*x2 <= 40, name="building_time")
    model.addConstr(2*x1 + 1.5*x2 <= 30, name="painting_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: sheds = {x1.varValue}, treehouses = {x2.varValue}")
        print(f"Maximum profit: ${700*x1.varValue + 500*x2.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
