
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("linda_bakery")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chocolate_chip") # chocolate chip cookies
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="oatmeal") # oatmeal cookies

# Set objective function
m.setObjective(4*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 20*x2 <= 360, "mixing_time")
m.addConstr(1*x1 + 2*x2 <= 50, "vanilla_extract")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Chocolate Chip Cookies:', x1.x)
    print('Oatmeal Cookies:', x2.x)
elif m.status == GRB.INF_OR_UNBD:
    print('Model is infeasible or unbounded')
    # Add more analysis if needed (e.g., compute IIS)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
    # Compute and print IIS
    m.computeIIS()
    m.write("model_iis.ilp")
    print("See model_iis.ilp for Infeasible Irreducible Set (IIS)")
elif m.status == GRB.UNBOUNDED:
    print('Model is unbounded')
else:
    print('Optimization ended with status %d' % m.status)

