
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="chocolate_chip_cookies", lb=0)
x2 = model.addVar(name="oatmeal_cookies", lb=0)

# Set the objective function
model.setObjective(4 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(10 * x1 + 20 * x2 <= 360, name="mixing_time")
model.addConstr(x1 + 2 * x2 <= 50, name="vanilla_extract")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of chocolate chip cookies: {x1.varValue}")
    print(f"Number of oatmeal cookies: {x2.varValue}")
    print(f"Maximum revenue: {model.objVal}")
else:
    print("No optimal solution found.")
